unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, xmldom, XMLIntf, msxmldom, XMLDoc, ExtCtrls, StdCtrls, Buttons,
  Rodzina;

type
  TMainForm = class(TForm)
    Memo1: TMemo;
    Memo2: TMemo;
    Panel1: TPanel;
    btnCLOSE: TBitBtn;
    btnSTART: TBitBtn;
    Splitter1: TSplitter;
    XMLDocument: TXMLDocument;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnSTARTClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnCLOSEClick(Sender: TObject);

  private
    procedure 	Wczytaj_z_pliku();
  public

  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.btnCLOSEClick(Sender: TObject);
begin
	Close();
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	XMLDocument.Active := false;
end;

procedure TMainForm.FormShow(Sender: TObject);
var
	szer : Integer;

begin
	Memo1.Clear();
	Memo2.Clear();

	WindowState    := wsMaximized;

	szer           := Screen.Width div 2;
	Memo1.Width    := szer;
	Memo2.Width    := szer;

	Memo1.Align    := alLeft;
	Memo2.Align    := alClient;

	Wczytaj_z_pliku();
end;

procedure TMainForm.Wczytaj_z_pliku();
var
	fn : String;

begin
   fn :=  ExtractFilePath(Application.ExeName);
   fn := fn + 'rodzina.xml';

   XMLDocument.FileName := fn;
   XMLDocument.Active   := true;
   Memo2.Lines.Add(XMLDocument.XML.Text);
   XMLDocument.Active   := false;
end;

procedure TMainForm.btnSTARTClick(Sender: TObject);
var
   rodzina : IXMLRodzinaType;
   ojciec  : IXMLOjciecType;

   kom     : String;

begin
	XMLDocument.XML.Clear();

	rodzina := Getrodzina(XMLDocument);
	XMLDocument.Active := true;

	ojciec := rodzina.Get_ojciec();

   kom := '';

	kom := ojciec.Get_imie();
	kom := 'Ojciec imie: ' + kom;
	Memo1.Lines.Add(kom);

	kom := ojciec.Get_pali();
	kom := 'Ojciec pali: ' + kom;
	Memo1.Lines.Add(kom);

	kom := ojciec.Get_posiada_prawo_jazdy();
	kom := 'Ojciec posiada prawo jazdy: ' + kom;
	Memo1.Lines.Add(kom);

	kom := ojciec.Get_pracuje();
	kom := 'Ojciec pracuje: ' + kom;
	Memo1.Lines.Add(kom);

	kom := ojciec.Get_uczy_sie();
	kom := 'Ojciec uczy si: ' + kom;
	Memo1.Lines.Add(kom);

	// zmianiamy zawarto
	ojciec.Set_imie('Wacek');
	ojciec.Set_pali('Nie');
	ojciec.Set_posiada_prawo_jazdy('Nie');
	ojciec.Set_pracuje('Nie');
	ojciec.Set_uczy_sie('Nie');

	Memo1.Lines.Add('   ');

	Memo2.Lines.Add('----- 2 -----');
	Memo2.Lines.Add(ojciec.GetXML());
end;

end.
